/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Wen Mar 14 10:17:10 2007
*  Last modified   :  %modify_time%
*/
/** @file 
*  \brief A brief description of this module 
*
*  \version CE2_TST_RC4.c#1:csrc:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************* Include Files ****************/

#include <memory.h>
#include "CryptoEngine2.h"
#include "CE2_TST_RC4.h"
#include "CE2_TST_Common.h"

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/

TST_RC4_TestDataStruct TST_RC4_Acceptance_TestData[] =
{
  { 
    /*TST_Name*/
    {"Acceptance test - RC4/16ByteKey/16ByteData "},
      /*TST_Key*/
    {0x03,0x5b,0x54,0x5a,0xaa,0x02,0xcd,0xe3,0x6c,0xe2,0x02,0x0c,0xdd,0x0c,0x4a,0x1c},
    /*TST_KeySize*/
    16*sizeof(DxUint8_t),
    /*TST_input_data*/
    {0x70,0xa3,0x6a,0xa5,0x2f,0x0a,0x7f,0xc2,0x0a,0x2f,0x38,0x67,0xe9,0x62,0x6c,0x9e},
    {0},
    /*TST_Expected_output_data for enc Input data for decrypt*/
    {0x7d,0xe2,0x51,0x8e,0xb2,0x8e,0xe5,0xb9,0x80,0xf7,0xfe,0x0d,0x84,0x2d,0x48,0x92}, 
    /*TST_dataSize*/
    16*sizeof(DxUint8_t),       
  },
  { 
    /*TST_Name*/
    {"Acceptance test - RC4/32ByteKey/32ByteData "},
      /*TST_Key*/
    {0x86,0xee,0x37,0x0c,0xef,0xd0,0x84,0x91,0x62,0xb6,0x56,0xd3,0xb6,0xae,0xcf,0x7a,
    0xc3,0xbf,0x31,0xd6,0x6a,0xd8,0xfc,0x73,0xd6,0x07,0x57,0xee,0x02,0xeb,0xb1,0x08},
    /*TST_KeySize*/
    32*sizeof(DxUint8_t),
    /*TST_input_data*/
    {0x54,0xcc,0xbb,0x58,0xf4,0xb8,0xd0,0xcd,0xbb,0x33,0x37,0x53,0x33,0xe8,0xfc,0x9b,
    0xdc,0xad,0xac,0xc8,0xd9,0x66,0xaf,0x76,0xea,0x26,0xd8,0xfb,0x9a,0x98,0x3b,0xec},
    {0},
    /*TST_Expected_output_data for enc Input data for decrypt*/
    {0x9f,0x9b,0x97,0x68,0xff,0xd4,0x2b,0x11,0x3f,0x64,0x72,0x14,0xdb,0xd9,0xae,0x39,
    0x35,0x89,0xdc,0x1d,0x7d,0x4c,0x71,0x4c,0xd9,0x63,0xf3,0x87,0x1e,0x59,0xb1,0x21}, 
    /*TST_dataSize*/
    32*sizeof(DxUint8_t),       
    },  
    { 
      /*TST_Name*/
      {"Acceptance test - RC4/41ByteKey/41ByteData "},
        /*TST_Key*/
      {0x1e,0xee,0x13,0x52,0x3e,0x75,0x0d,0xf9,0xcb,0x83,0xff,0x11,0xfb,0xcc,0xdd,0x8c,
      0x87,0x70,0x55,0x33,0xa4,0x23,0x60,0xea,0x35,0x8b,0x18,0x36,0x3f,0xe9,0xc9,0xfc,
      0x9d,0xfc,0x4a,0x8c,0xf5,0x23,0x8e,0xdd,0xea},
      /*TST_KeySize*/
      41*sizeof(DxUint8_t),
      /*TST_input_data*/
      {0xb9,0x09,0xbd,0x2a,0xf9,0x3b,0x93,0xa0,0xf0,0x87,0x5b,0x86,0xbd,0xe4,0x3b,0x42,
      0xbd,0x87,0xa8,0x3c,0x47,0xbe,0xc3,0xe5,0x9a,0x1c,0xe9,0xf9,0x13,0xd6,0x85,0x01,
      0xa4,0x6d,0x29,0x1b,0x81,0x8d,0xde,0xfd,0x1c},
      {0},
      /*TST_Expected_output_data for enc Input data for decrypt*/
      {0x41,0xcb,0x06,0x67,0x85,0x7a,0x94,0x0c,0x74,0x07,0x6f,0x69,0xfd,0xcd,0xcf,0x1b,
      0x74,0xad,0x8e,0xe3,0x62,0xaf,0xf1,0x15,0x62,0xc9,0x92,0x93,0x4e,0x7c,0xd4,0x78,
      0x04,0x0d,0xe1,0x0a,0x22,0x0b,0xf7,0x70,0x96}, 
      /*TST_dataSize*/
      41*sizeof(DxUint8_t),       
    },
    { 
      /*TST_Name*/
      {"Acceptance test - RC4/256ByteKey/512ByteData "},
        /*TST_Key*/
      {0xaa,0xd8,0x2e,0xfd,0xcc,0x99,0xb4,0x52,0x59,0x8b,0x53,0x53,0xf9,0x04,0x1a,0xa7,
      0x44,0x90,0x75,0xd7,0x31,0x94,0x47,0x0d,0xd1,0x31,0x38,0x1b,0x3d,0x6b,0x51,0xbe,
      0xcd,0x8b,0xc6,0x24,0x8a,0xc1,0x12,0xad,0xe6,0x0e,0x49,0xef,0xab,0x61,0xaa,0xfc,
      0x32,0x01,0x74,0xe7,0xd5,0x2a,0xfc,0x84,0xa6,0xfb,0xfb,0x70,0x62,0x90,0x2c,0x51,
      0xa0,0x6b,0x17,0x5f,0x4e,0x18,0x27,0x24,0x5e,0x10,0x03,0x7f,0xbd,0xdf,0x1b,0xef,
      0x85,0x82,0x81,0x0e,0x73,0x13,0xfb,0x5c,0x9b,0xa8,0x56,0x3e,0x5a,0x78,0xfd,0x47,
      0x8d,0x3f,0xca,0xb5,0x00,0xe4,0x1b,0x3f,0x2a,0x59,0x29,0x0e,0x17,0xc4,0x95,0x09,
      0xa5,0xdc,0x44,0x55,0xf3,0x95,0x6d,0x1c,0x17,0xff,0xf0,0x8e,0x0f,0x6b,0xea,0x26,
      0xfa,0xd1,0x86,0x2f,0x89,0x6e,0x16,0x86,0xb0,0xb1,0x62,0xa1,0xa1,0x58,0x3f,0xd0,
      0xfa,0xd7,0x64,0xc3,0x3d,0xf9,0x7a,0x4d,0x82,0xc9,0x72,0x67,0x68,0xb3,0x1b,0x78,
      0x51,0xe7,0xf4,0xd4,0xcf,0xfe,0x3f,0x82,0x59,0xe0,0x56,0x42,0x43,0xe5,0x42,0xce,
      0xed,0x3a,0x8a,0x61,0x3a,0x87,0x49,0x76,0x43,0xce,0x83,0xd2,0x4d,0x97,0xb9,0xc4,
      0xf9,0x4a,0xbb,0xac,0xbb,0xdc,0xbe,0xba,0x8d,0xad,0xae,0xf8,0xe5,0xb1,0xc6,0x8b,
      0xe4,0xcf,0x5d,0x36,0xd0,0x86,0x03,0x1f,0xc4,0xd6,0xcc,0xd6,0xa6,0x5e,0xec,0x93,
      0x5a,0xc2,0x84,0xbf,0x35,0x4f,0xbc,0xb6,0xb5,0xe2,0x12,0xcc,0x6f,0x05,0xf2,0x8e,
      0x48,0x5c,0x86,0x4a,0xe8,0x40,0xcf,0xd1,0x6c,0xa9,0xf5,0x7b,0x5b,0x51,0xdb,0x6c},
      /*TST_KeySize*/
      256*sizeof(DxUint8_t),
      /*TST_input_data*/
      {0xbe,0x4e,0xe3,0x04,0xf3,0x62,0xcd,0x17,0x89,0x71,0x6e,0x08,0x77,0xa6,0x16,0x7a,
      0x24,0xd8,0x10,0x1c,0xcf,0x5f,0x24,0x23,0x2e,0x27,0x60,0xf8,0x55,0x03,0x19,0x2d,
      0xda,0x43,0x2c,0xb6,0x37,0x88,0x89,0x56,0x6f,0xd7,0xf3,0x57,0xf5,0xed,0x01,0x7e,
      0xc9,0xd2,0x69,0x3e,0xe4,0xb1,0x7d,0x2c,0xd6,0xe7,0xf6,0xb3,0xae,0x5a,0xf1,0x09,
      0x1a,0x0c,0x37,0x61,0xcf,0xf0,0xc1,0x63,0x2b,0xfc,0x7c,0xd9,0x19,0x7f,0x49,0xab,
      0x36,0xb5,0x48,0x0d,0x32,0x98,0x56,0xf7,0x78,0xfa,0xd4,0xd5,0x11,0xd1,0xab,0x81,
      0xc5,0xd2,0x8c,0x6e,0x84,0x41,0x7d,0x26,0x05,0x07,0x91,0xf6,0xad,0x05,0xf6,0xe7,
      0xb2,0xa8,0x35,0xf1,0x80,0xbd,0xb6,0x6c,0x5c,0x87,0x83,0xc7,0x47,0x0f,0x4d,0x7c,
      0x25,0xbc,0xb4,0x43,0x1e,0x23,0xc3,0x87,0x45,0x20,0xba,0x16,0x77,0x26,0x11,0x1c,
      0x86,0xd3,0xb9,0x52,0x97,0xc8,0xa5,0x73,0xc9,0xb7,0x89,0xf0,0x18,0xbd,0xe2,0xe4,
      0x80,0xf3,0x36,0x4a,0x65,0x40,0x9d,0x6e,0x32,0x71,0x80,0xa1,0x41,0x8b,0xa1,0x31,
      0xfb,0x5f,0x5b,0x98,0x40,0x60,0x2c,0xf4,0x09,0xb2,0x70,0xb7,0x4b,0x83,0x6f,0xa0,
      0x1f,0x9e,0x9a,0xea,0x21,0x3d,0x12,0xc3,0x15,0x1f,0x6a,0xff,0xd1,0xdb,0xae,0x0e,
      0x57,0x74,0xa4,0x2b,0x41,0x2d,0x51,0xd7,0x62,0x9f,0xbf,0x86,0xaa,0x08,0xfe,0x98,
      0x4a,0xe6,0x69,0x8a,0x19,0xc5,0x2a,0x6e,0x36,0x55,0x01,0x98,0xef,0xbf,0x41,0x9b,
      0xe2,0x39,0x1b,0x74,0x62,0xd9,0x1e,0x04,0x1d,0xa6,0xff,0xc4,0xfb,0xf5,0x96,0xb4,
      0x49,0xf3,0x2a,0x94,0x16,0x7e,0xee,0x57,0xdd,0x39,0xcb,0xd5,0x65,0xdf,0x60,0xc0,
      0xe6,0xd7,0x48,0xd9,0x6d,0x09,0x9b,0x63,0x81,0xf1,0xb7,0xd8,0x07,0xf1,0x40,0xdc,
      0x63,0xec,0x65,0x6f,0xe0,0x10,0x65,0x66,0x52,0xf3,0x52,0x1c,0xfa,0xe2,0x16,0x65,
      0xa9,0x76,0xb3,0xc3,0x28,0x67,0xcf,0xdd,0xd8,0xa5,0x6f,0x2c,0x96,0xa5,0x03,0xf8,
      0xe1,0xf9,0xa3,0x83,0x3f,0x24,0x98,0x84,0xdc,0xac,0x1e,0xd6,0x75,0x71,0x68,0x72,
      0x74,0x3c,0xe5,0x9b,0x5d,0x9b,0xc2,0x58,0x68,0xed,0xb0,0x27,0x70,0xb9,0xe7,0xf0,
      0x0b,0x44,0x6a,0x38,0xfb,0x62,0x8d,0x97,0xc5,0x8c,0xb5,0x6c,0x9f,0x33,0x60,0xcf,
      0x8f,0x54,0x65,0xc7,0xd2,0x4d,0x7c,0xbd,0x7b,0xef,0x00,0x31,0x5c,0xd4,0xf4,0xac,
      0x29,0xf2,0x45,0xf6,0xdb,0x71,0x4e,0x88,0x53,0xba,0xa1,0x44,0x40,0xd1,0x05,0x64,
      0x42,0xe4,0xbb,0xb1,0x50,0x24,0x06,0xf5,0x57,0xd3,0xea,0xb2,0x23,0x9e,0x33,0x14,
      0x83,0x2e,0xb9,0x25,0xa8,0xfa,0xe3,0x40,0xcf,0x5f,0x6a,0xc8,0x20,0xf2,0x5f,0x19,
      0xd5,0x15,0x70,0xbf,0x9e,0xc8,0x67,0xe7,0x44,0xc2,0xf3,0x12,0x8d,0xc1,0xab,0x11,
      0x61,0x1e,0x50,0x2d,0x2a,0xa4,0x52,0xa6,0x81,0xa2,0x96,0x5f,0x06,0x3f,0x77,0xd7,
      0x8f,0x0e,0x0b,0x5b,0x86,0xe2,0xa7,0x7a,0x8c,0xe4,0xa5,0xba,0x62,0xe2,0x64,0x89,
      0x0a,0xea,0x91,0x76,0x29,0x18,0xa5,0xa1,0xb0,0xac,0xaf,0x70,0xbb,0x5f,0x54,0x84,
      0xba,0xf8,0x14,0xec,0xce,0x1a,0xcf,0x98,0x76,0x60,0x87,0x10,0x6a,0xac,0x67,0x66},
      {0},
      /*TST_Expected_output_data for enc Input data for decrypt*/
      {0x18,0x2f,0x78,0xa9,0x52,0xdd,0x8b,0x4a,0x69,0xde,0xdf,0xdd,0xd9,0x55,0x65,0xf4,
      0xad,0x91,0x82,0x70,0xd2,0x73,0x27,0xbf,0xed,0x09,0x1b,0xb8,0x77,0x10,0x0b,0xd2,
      0x56,0xc8,0x54,0x40,0x9a,0x96,0x36,0xc3,0xc2,0xd7,0xa0,0x7a,0x57,0x28,0x29,0xb1,
      0x5d,0xe9,0x3f,0xe6,0x9e,0x34,0x53,0x6e,0x77,0x2b,0x52,0x2f,0xd8,0xa7,0xa7,0x4e,
      0x29,0x1b,0x5d,0xc8,0x7d,0xa3,0x75,0x12,0xd0,0x17,0xa4,0x31,0x70,0xde,0x77,0x9b,
      0x4e,0x40,0xff,0x94,0xd3,0x99,0x12,0xf0,0x56,0x28,0x8e,0x99,0x97,0x2e,0xee,0x98,
      0xce,0xac,0xf6,0xb3,0xb4,0x59,0x33,0xa7,0xc7,0xc8,0xd3,0x9d,0xbe,0xf8,0xb5,0xb5,
      0xda,0xf0,0xb1,0xb7,0xc4,0x40,0x33,0x66,0xc0,0x48,0x8e,0x06,0x80,0xe1,0xcb,0x0b,
      0x54,0x60,0xc7,0x0c,0x45,0x3b,0x19,0x7c,0x88,0x53,0x4d,0x41,0x7b,0xad,0x1c,0x5b,
      0x78,0xd8,0xe9,0xe7,0xe0,0xfd,0x8d,0xc3,0x51,0x18,0x6a,0xea,0x35,0x74,0x6f,0xad,
      0x91,0xc7,0x7c,0x7a,0x5d,0x64,0x76,0xa0,0x0f,0xec,0x02,0xf8,0x0e,0x4f,0xd1,0x13,
      0xcf,0xc4,0x23,0xbc,0x82,0x7b,0xce,0xc7,0x82,0x43,0xea,0x10,0xad,0xe8,0x27,0xb5,
      0x5b,0x6b,0x7b,0x22,0x04,0x4b,0x23,0x51,0x75,0x79,0x8d,0x8e,0x28,0x81,0x91,0xe7,
      0x02,0xd8,0x53,0xdb,0xa9,0x92,0xae,0x3b,0x7c,0x0b,0xde,0x5f,0x39,0xe1,0xbb,0x0e,
      0x9a,0xa3,0xac,0x69,0x22,0xde,0x12,0xf4,0x58,0x09,0xfa,0x65,0xdf,0x9f,0x66,0xf8,
      0x38,0x0f,0x92,0x3d,0xa0,0x5f,0x4d,0x98,0x27,0xbe,0x0c,0xa3,0x4e,0x6d,0x66,0x8f,
      0x1e,0xa4,0x81,0x80,0xe4,0x54,0x86,0x15,0xec,0xe1,0x4c,0x20,0xa9,0x03,0x07,0x0d,
      0x64,0x49,0x55,0x0e,0x6a,0x3e,0x7b,0x60,0x5f,0x21,0x16,0x06,0x84,0x1c,0x14,0x4c,
      0x9f,0x51,0x9a,0xc6,0x0d,0x68,0x1b,0xfc,0xb5,0xe5,0x94,0x2a,0xe0,0x23,0x7b,0xbe,
      0xbe,0xfe,0x7d,0xf0,0x93,0x4d,0x0a,0x60,0xe3,0x85,0x94,0x1e,0x6a,0x6b,0xeb,0x54,
      0x78,0xe1,0x19,0x04,0x22,0xb8,0x98,0x09,0x1d,0xb6,0xf1,0x82,0x33,0xcf,0x70,0xcb,
      0x23,0xe7,0x38,0x69,0xfe,0x5a,0xe7,0xbc,0x2b,0x51,0xf0,0xd5,0x86,0x48,0x2b,0x64,
      0xbe,0x1c,0x9d,0xb5,0xb5,0xd2,0xbf,0xf4,0x24,0x45,0x18,0xc2,0x78,0xa3,0xdd,0xb6,
      0x58,0x7d,0x88,0x8c,0x55,0x27,0x7b,0x83,0x6b,0xa0,0x0e,0x02,0x09,0x9a,0x42,0x5d,
      0xc7,0xee,0x52,0xc2,0x6a,0x33,0xe0,0x18,0x8b,0x67,0x06,0xc6,0x65,0xe5,0x6b,0x6a,
      0x2c,0xd0,0xb9,0x92,0xed,0xf1,0x20,0x88,0xff,0x0a,0x67,0x9e,0x59,0x92,0xd5,0x35,
      0x7a,0xee,0x6b,0xde,0x1f,0x7b,0xae,0xe5,0x73,0xbe,0xea,0x54,0xd6,0x70,0xd6,0x84,
      0xc3,0x75,0x6a,0xc4,0xfd,0x7f,0xbb,0xf3,0xc2,0xcf,0x87,0x68,0x2f,0xd9,0x5e,0x82,
      0x1b,0xb8,0x78,0xe4,0xcd,0xc6,0x2d,0x74,0x90,0x2d,0x46,0x26,0x39,0x4e,0x73,0x3d,
      0x51,0x59,0xde,0x01,0xb3,0x5c,0x47,0xd2,0x96,0xff,0x67,0x67,0x84,0x80,0x17,0xcc,
      0xac,0xde,0xa6,0x36,0xb0,0xf1,0x71,0xb8,0x90,0x4b,0xe7,0x01,0x24,0x97,0xf2,0xae,
      0xf7,0x9a,0x18,0x93,0xcf,0xc8,0x42,0x03,0x3d,0x47,0x63,0x54,0x77,0xf9,0xe5,0x02}, 
      /*TST_dataSize*/
      512*sizeof(DxUint8_t),      
      },  
      { 
        /*TST_Name*/
        {"Acceptance test - RC4/32ByteKey/1536ByteData "},
          /*TST_Key*/
        {0xe3,0x16,0x77,0xd1,0xfe,0xb9,0xf7,0x5b,0x84,0xf9,0xfb,0x42,0x38,0xe3,0x6e,0x93,
        0x84,0x84,0x3a,0x64,0xb3,0x4f,0x16,0x5d,0x60,0xbf,0x9f,0x78,0x2e,0x3d,0xab,0x04},
        /*TST_KeySize*/
        32*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0xc8,0xd7,0x82,0xea,0xac,0xe6,0x63,0x5d,0x52,0x3b,0xd9,0xe0,0x55,0xce,0x86,0xe2,
        0x76,0x30,0x4f,0x01,0xef,0x84,0x54,0x2a,0x05,0xcb,0x25,0x02,0xdd,0x66,0x33,0x85,
        0x90,0xd5,0x84,0xed,0x81,0xc5,0xab,0xd6,0xef,0x4a,0xf8,0x9f,0xc6,0x69,0xec,0x13,
        0xbb,0xd9,0xef,0x49,0x97,0x0a,0x45,0xc8,0xd3,0x67,0x3f,0xef,0x66,0xd9,0xae,0x95,
        0xdb,0x8c,0x9d,0xec,0xa6,0xf5,0x40,0xab,0xb8,0x14,0x27,0x6c,0x51,0xf6,0xb7,0x52,
        0x16,0x7f,0xdb,0xf0,0x63,0x66,0xf7,0x66,0xe2,0x81,0x1e,0xcd,0x5d,0x43,0x84,0xd6,
        0xd0,0x83,0x36,0xad,0xc3,0x7e,0x08,0x24,0xd6,0x20,0xcf,0x0d,0x9e,0x7f,0xd1,0xe7,
        0xaf,0xa9,0x7a,0xbe,0xfa,0x9f,0x51,0x4c,0x5a,0xa1,0x2a,0x64,0x69,0xac,0x9c,0x91,
        0x98,0x42,0xb5,0xfa,0x7f,0x69,0xed,0x88,0x71,0xf6,0x59,0x4b,0x54,0x0b,0x21,0x1a,
        0xaf,0xdf,0x34,0x7a,0x05,0xbd,0x3a,0xc2,0x62,0x50,0xcb,0x7c,0x33,0x1d,0xde,0x0d,
        0x5a,0x51,0x84,0x99,0x82,0xbd,0xd6,0x21,0xb0,0x1f,0x2b,0xee,0x1b,0xa3,0x8f,0x33,
        0x3e,0xa9,0x71,0xee,0x2b,0xc9,0x9c,0x0f,0x22,0x14,0x69,0xdc,0x62,0x9d,0x32,0x94,
        0x3f,0x39,0x09,0x52,0x75,0x82,0xaa,0x35,0xbc,0x22,0xaf,0xbe,0x9d,0x4e,0x03,0x79,
        0x83,0x90,0x99,0xe0,0x15,0xca,0x5e,0x7c,0xc3,0x78,0x6c,0x4d,0x9f,0x35,0x80,0x6c,
        0x6f,0x81,0xae,0xef,0x00,0xc1,0x53,0x0d,0xbd,0x87,0x4c,0x83,0x7f,0x14,0x65,0x35,
        0xa7,0x1b,0x14,0x19,0x6b,0xc8,0x68,0x51,0x6d,0x01,0x3c,0x97,0x92,0xec,0xb0,0xde,
        0x11,0xb1,0xda,0x36,0xca,0x81,0xb8,0xf1,0xda,0xd7,0x69,0x04,0x6c,0xfd,0x9d,0xb0,
        0xd1,0xd3,0x4b,0x61,0xd4,0xcc,0xa2,0xd6,0x47,0x39,0x41,0x82,0xe2,0xca,0xaa,0x32,
        0x4e,0x51,0xf4,0xf1,0x7c,0xca,0xc1,0x28,0x3b,0x99,0x70,0x0a,0x0a,0x12,0x94,0x2f,
        0x2a,0x3e,0xa4,0x7f,0xf8,0xdc,0xf4,0x52,0x7a,0xa7,0xe3,0xd6,0x38,0xd7,0x56,0xb0,
        0x4d,0xea,0x66,0xe6,0xbd,0xa4,0x56,0xfc,0x09,0x55,0xc8,0x5d,0x01,0x5a,0x30,0xfd,
        0xda,0xe6,0x88,0x3d,0x80,0x03,0x46,0x0f,0x2d,0xd3,0x8b,0x5a,0x3b,0x1c,0x9d,0xa0,
        0x37,0x03,0x97,0xde,0x36,0x18,0x5f,0xb3,0x6c,0x93,0xd9,0xc5,0xfa,0xdd,0x5a,0x61,
        0x08,0x53,0x60,0x61,0x14,0x46,0x80,0x53,0x89,0x46,0x9f,0xd7,0x94,0xa0,0x65,0x49,
        0x33,0x25,0xef,0xa0,0x8f,0x2d,0xc4,0x96,0x8b,0xdc,0x0b,0x0a,0x9d,0xa4,0xfb,0xa2,
        0xdd,0x0b,0x92,0xb4,0x5b,0xaf,0x8a,0x67,0xb6,0x87,0x89,0x15,0xea,0x6b,0x98,0xf4,
        0x6a,0xd7,0xd6,0xf6,0x6f,0xec,0x6d,0xed,0x8f,0xb7,0xc6,0xf3,0x91,0xb6,0xf9,0x09,
        0x80,0x98,0x88,0xfe,0xfe,0x45,0x4c,0x93,0xdb,0x1e,0xaf,0xdc,0xe6,0x86,0x1c,0xe9,
        0x03,0xa1,0xb4,0xa6,0x7e,0x5b,0x43,0x00,0x9f,0xad,0x72,0x49,0x7f,0x1c,0x3e,0xde,
        0x19,0x82,0xa8,0x07,0xa4,0x10,0xae,0x1e,0x21,0x94,0x7b,0xf4,0x30,0xf8,0xdb,0x70,
        0x27,0x0b,0xf1,0x79,0x65,0x85,0x2c,0x16,0xe4,0x45,0x77,0xd4,0x0e,0xdc,0xb0,0x69,
        0xd2,0x4f,0x5c,0x96,0xf6,0x19,0x99,0x52,0xaf,0x70,0x53,0x24,0x6f,0xc9,0xbb,0xd1,
        0xfe,0x9e,0xf5,0x37,0xcc,0x6f,0x11,0x79,0x86,0x07,0x3d,0x5c,0xe7,0x00,0x39,0xf1,
        0xd1,0x89,0x0b,0x75,0x9c,0x67,0xf3,0x75,0xae,0x3a,0xa1,0x35,0x4b,0x02,0xa6,0x53,
        0xaf,0xe1,0x29,0xa8,0x5a,0x23,0xdb,0x6f,0xac,0x7b,0x2d,0xa9,0xb1,0x8f,0xc0,0xc0,
        0x3e,0xb7,0x1c,0x6a,0x3d,0x02,0xa6,0xd0,0x45,0x7b,0xcc,0xf0,0x6e,0xaa,0x83,0x3f,
        0x63,0x5d,0xf3,0x93,0xb8,0xa8,0x70,0x41,0x7e,0x2a,0xad,0x82,0x15,0x92,0x2c,0x1c,
        0x42,0x62,0xf9,0x3e,0x81,0xf3,0x98,0xab,0x9d,0xb9,0x3c,0x1a,0x7d,0xc9,0x3a,0xdd,
        0x41,0x98,0xbc,0xc2,0x8e,0x06,0xba,0x37,0x25,0x9b,0x26,0xb1,0xbb,0x10,0x67,0x4e,
        0x05,0x11,0x09,0xb9,0x12,0x41,0xb3,0x4e,0xdd,0x7f,0x59,0x7e,0x23,0x68,0xb2,0x75,
        0x72,0x1c,0xed,0xfb,0x83,0x45,0xa0,0x98,0xc9,0x56,0x01,0xfc,0x4a,0x11,0x58,0x9d,
        0xae,0x4c,0xb4,0xa2,0x95,0xf4,0xdd,0x00,0x2e,0x52,0x8b,0xe3,0x06,0x8d,0xd5,0x4f,
        0x1d,0x71,0xec,0x07,0x3f,0x6e,0x09,0xae,0x91,0xe4,0xa4,0x2c,0x6b,0x9e,0xe7,0x53,
        0x65,0x9c,0x62,0xc3,0xb5,0x15,0x00,0x0a,0xb8,0xbc,0x3a,0x10,0xce,0x43,0x8a,0xb3,
        0x6b,0x1d,0x23,0xae,0x6b,0x89,0xdf,0xbf,0xa6,0xcc,0x79,0x09,0xc5,0xbd,0xfc,0xb7,
        0x54,0x87,0x7b,0xe2,0x18,0xab,0x03,0xb4,0xa2,0x44,0xce,0xce,0x24,0x8f,0xb9,0xe8,
        0x84,0xaa,0xf8,0xb7,0xaf,0x9c,0x09,0x14,0x30,0x96,0xe6,0x5a,0x01,0x79,0x7f,0x10,
        0xa0,0x97,0x67,0xc8,0x66,0xbe,0xce,0x46,0x15,0x73,0xaf,0xe5,0xb0,0x7b,0x4a,0x37,
        0x8f,0xa0,0xd5,0xec,0xb2,0xb1,0x6f,0xf5,0x56,0xcb,0x55,0xe9,0xc6,0xd7,0x58,0xa7,
        0x74,0x54,0x8f,0x3d,0x48,0x57,0x49,0x08,0x38,0xcf,0x45,0x1d,0x19,0x0e,0x26,0xe8,
        0xb4,0x85,0x21,0x13,0x1d,0xcf,0xf9,0xa9,0x40,0xf2,0x2d,0x7c,0xbd,0xe1,0x70,0xc4,
        0xf6,0x45,0x59,0x08,0x65,0x7c,0x5c,0x42,0x34,0xe2,0xf9,0x3e,0x07,0x50,0x33,0x43,
        0x1d,0xe3,0x44,0xf5,0x97,0xff,0x8f,0x7a,0x17,0x93,0xd6,0xdc,0x8d,0x9e,0xad,0xae,
        0x4e,0xf2,0x2e,0xf3,0x67,0x38,0xef,0x3b,0x30,0x34,0x31,0x0f,0x24,0x4a,0x5a,0x8f,
        0xef,0x41,0xa6,0x5a,0xc9,0x48,0x19,0xae,0x03,0x36,0xb8,0xd1,0xdf,0x16,0xf8,0xaf,
        0xa5,0xe3,0x77,0xc4,0xf3,0x90,0xea,0x3c,0x55,0x4b,0x56,0x59,0x15,0x03,0x84,0x16,
        0x55,0x28,0xaf,0x0a,0x5a,0xb2,0x7f,0x8e,0x2b,0x64,0x3b,0x22,0x5b,0x52,0x3a,0x0d,
        0x23,0xa1,0x9a,0x44,0xb4,0x8e,0x35,0x8d,0xca,0xb1,0xd1,0xe4,0x85,0x83,0x97,0x1e,
        0x75,0x1f,0xc7,0xcc,0xf3,0x45,0xa9,0x62,0xb8,0xa4,0xc7,0x99,0xa8,0x59,0x59,0x11,
        0xef,0xb3,0x01,0x3b,0x4f,0x39,0xb8,0x76,0xb8,0xee,0x08,0x78,0x1a,0xd3,0x7d,0xf0,
        0x77,0xae,0x56,0x69,0x3c,0x0a,0x7f,0x72,0xd1,0x7f,0xc4,0xfc,0x6f,0x33,0x3f,0x03,
        0x32,0xa1,0x12,0x71,0x6f,0x99,0x5c,0x3f,0x47,0x88,0x65,0xdd,0x7c,0xfa,0x1c,0xd4,
        0x84,0x5d,0xc4,0xaa,0xdc,0x08,0xea,0x05,0x9f,0x7c,0x9a,0x14,0x57,0xe9,0xd2,0x2b,
        0x13,0xf4,0x37,0xad,0xba,0xb7,0x07,0x2f,0x9e,0x09,0x4f,0xda,0x54,0x00,0x5e,0x11,
        0xc4,0xb5,0x79,0x54,0x7c,0x47,0xd0,0x65,0x4a,0x23,0xb1,0xa9,0x09,0x82,0xfc,0xd0,
        0xbb,0x33,0xd7,0xb9,0xd8,0x9a,0xa2,0x8f,0xe6,0xf9,0x2e,0x39,0x4a,0xee,0x29,0xf1,
        0x5e,0x3d,0xdd,0x32,0xc3,0xd0,0x1b,0xd8,0xf9,0xfc,0x71,0x83,0x2c,0x06,0xa3,0x3c,
        0x51,0xe6,0x59,0x5b,0x72,0x4a,0x16,0xa7,0x46,0xde,0x69,0xc0,0x05,0xcb,0x67,0xba,
        0x7a,0x7d,0x58,0x0b,0x5a,0xaa,0xb1,0xa7,0xd4,0x90,0x43,0x69,0x69,0x7e,0xb1,0xb5,
        0xfe,0x95,0x27,0x5c,0x30,0xd0,0x49,0xbf,0xe7,0x42,0x6a,0x38,0x2e,0x9f,0xff,0xb5,
        0x42,0xfe,0x53,0xa6,0xe8,0xdd,0x7c,0x1a,0x04,0x66,0x8d,0x24,0x68,0xf1,0x0d,0x84,
        0xea,0xc9,0xa8,0x83,0xb9,0x33,0x25,0x1f,0xf1,0xac,0x98,0x68,0x6c,0x73,0xd9,0x2a,
        0xdc,0x47,0x34,0xcc,0x16,0x72,0x62,0x78,0xb1,0x06,0xb8,0x7d,0xd0,0x67,0x9f,0xf1,
        0x3c,0x09,0x44,0x9a,0xb6,0x7b,0x91,0x0f,0x8b,0xa5,0x5b,0x1a,0x68,0x4e,0xdd,0x61,
        0x70,0xe1,0x65,0x45,0x8c,0x70,0x4d,0x0b,0x02,0xf9,0x2d,0x39,0x4a,0xe8,0x4f,0x43,
        0x1d,0xde,0x63,0x67,0xce,0xb1,0x74,0xd6,0xdd,0xb4,0x1b,0x14,0xca,0x38,0xf3,0xa1,
        0x27,0x52,0x4c,0xd9,0xf1,0xdf,0x24,0x19,0x20,0xc6,0x53,0x23,0x7d,0x7d,0x05,0xc4,
        0xb4,0xcf,0x6d,0xb4,0xaa,0xdc,0xb8,0xbd,0x10,0x61,0x40,0x1f,0x39,0x39,0x03,0x34,
        0x28,0x24,0x53,0x50,0xee,0xc8,0xcf,0xeb,0x33,0xf5,0x91,0x02,0x12,0x2d,0xa9,0xba,
        0x2a,0x64,0xca,0x47,0xf1,0x04,0x44,0x0c,0x4c,0x34,0x32,0x03,0x5d,0x5a,0xf5,0x60,
        0x9c,0xde,0xe1,0x71,0x2a,0x32,0x35,0xc9,0x62,0x0f,0x51,0x9d,0xb0,0x01,0x23,0x6e,
        0xa6,0x25,0xe3,0xe8,0x4c,0x31,0x00,0x0b,0xb8,0xb6,0x5a,0x88,0xdf,0xa2,0xb1,0x6e,
        0xab,0x09,0x5d,0x05,0x4e,0x25,0x40,0xfa,0xd5,0x9b,0xfa,0xbd,0x00,0xff,0x5b,0x28,
        0x51,0x9b,0x1e,0x61,0x63,0x6c,0xd4,0x01,0x7d,0x6e,0x1e,0x76,0x67,0x1a,0x1f,0xa6,
        0x7c,0x2c,0x31,0xd4,0x01,0xa9,0xd7,0xc8,0xb5,0x21,0xf4,0x2a,0xa9,0x31,0x3a,0x30,
        0x52,0x4d,0xe4,0x79,0xdd,0xbc,0xa8,0x38,0xc2,0xe4,0xe7,0x94,0x9c,0xc8,0x28,0x4f,
        0x38,0xcf,0xc4,0xa6,0xec,0xc7,0xe2,0x79,0x2a,0x29,0xa6,0xac,0x54,0x9f,0xa6,0xcd,
        0xd2,0xc3,0x9e,0xf7,0x63,0x2a,0x64,0xf6,0xb0,0xa1,0x1e,0xab,0x27,0xb6,0xb2,0xb2,
        0x06,0x7b,0x7e,0x43,0xb6,0x86,0x4a,0x56,0x5b,0x3c,0x7a,0x0b,0xa9,0x50,0x88,0x48,
        0xf9,0x86,0xb2,0xa4,0x9c,0xbd,0xf0,0x84,0x6f,0x2c,0x29,0x83,0xaf,0xec,0xa6,0x18,
        0x0f,0xb6,0xc7,0x73,0x08,0xef,0xf5,0xa7,0x71,0xe1,0xd7,0x0e,0x4f,0x4c,0xc9,0xe9,
        0xee,0x1d,0x8a,0x48,0x31,0x7d,0x34,0x2a,0x26,0x0d,0x72,0xe4,0xdd,0x70,0xed,0xc7,
        0x7b,0x0b,0x07,0xfd,0x8a,0x08,0xcc,0xb4,0x93,0xa1,0x25,0x7f,0xef,0x9b,0x4f,0xf8,
        0xda,0x10,0x8c,0xab,0xc9,0x72,0x19,0x2f,0xfe,0xcd,0x5f,0x96,0x59,0x4c,0x6d,0x08,
        0x71,0xff,0xa6,0xaa,0xe3,0xdb,0xb7,0xc4,0xea,0x03,0xcd,0x24,0x30,0x46,0x04,0xbd,
        0xe4,0xe8,0x22,0x94,0x0d,0xa5,0x85,0xdd,0x1e,0xf3,0x5a,0x60,0xca,0x88,0x10,0x22},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/
        {0x65,0xf5,0xe9,0x99,0x2c,0x9b,0x14,0xa4,0xf6,0xcf,0x29,0xe7,0x29,0x34,0xca,0x02,
        0xa1,0x03,0x8c,0xd6,0xf9,0xd5,0x4f,0xe9,0x41,0x44,0x61,0xd0,0xdb,0x6d,0x5a,0x3b,
        0x01,0x0e,0x5b,0x8e,0xc3,0x03,0xbb,0x21,0xcb,0xfe,0x4b,0x99,0x9e,0x6a,0x7e,0x31,
        0x9a,0x23,0xcd,0x29,0x7b,0x4c,0x4b,0x4b,0x34,0x50,0x39,0xf4,0x62,0x03,0x22,0x94,
        0x20,0xac,0x02,0x58,0x9c,0x44,0x1e,0xad,0x3c,0xb1,0xa7,0xde,0xdb,0x18,0xcb,0x86,
        0x40,0x4e,0xbd,0xbb,0x79,0x4c,0x73,0xd9,0xfa,0xda,0x51,0xc9,0x2f,0x49,0x84,0xbe,
        0x6b,0xa9,0x55,0x25,0x55,0xd8,0xd7,0xf3,0x0e,0x43,0x61,0xd6,0xad,0x12,0x52,0x4e,
        0x5f,0x10,0x10,0x92,0xa7,0xf9,0xcd,0xf4,0xc4,0xe1,0x19,0xf6,0xf2,0xfa,0x26,0x1d,
        0x90,0x7e,0xc1,0x8e,0xc5,0x95,0x36,0xb1,0x5e,0xfb,0xb4,0x7e,0xcf,0xa1,0xd2,0x6d,
        0x5d,0x48,0x33,0x3f,0xb1,0xc8,0x39,0xeb,0xa1,0x55,0xeb,0xc5,0xfe,0xb4,0x10,0x10,
        0xbb,0x95,0xd3,0x87,0xe3,0xd1,0xed,0x64,0xb4,0x97,0xa1,0x01,0x74,0x55,0x1f,0xda,
        0x7e,0xce,0xcc,0x53,0xe4,0x7b,0x7a,0x70,0xc7,0xda,0xee,0xac,0x5e,0xd8,0x0c,0x0a,
        0x09,0xdb,0xfe,0xfd,0x4e,0x2f,0xd9,0x3b,0x08,0x81,0xca,0x88,0xcd,0xf6,0x5b,0xf7,
        0xbf,0xfd,0x45,0xa4,0x6d,0xc9,0x96,0xa8,0x3d,0x37,0xfb,0x14,0xfe,0xf1,0x55,0xb0,
        0xf3,0xb5,0x4b,0xf6,0x22,0x54,0x2b,0xfb,0x8a,0x8f,0x5f,0xa4,0xeb,0xcc,0x58,0x17,
        0x8d,0x8b,0x39,0x16,0xa8,0x90,0xa7,0x6b,0x16,0x69,0x21,0xb5,0x81,0xb4,0xab,0x62,
        0x87,0x51,0x7b,0x99,0x85,0x87,0x7c,0xac,0x91,0xaf,0x9d,0x2e,0x6b,0x02,0xde,0xe0,
        0xb7,0x05,0x59,0x83,0xdd,0x91,0x6a,0xe4,0x8d,0x2a,0xe9,0x4b,0xd9,0xe7,0xc1,0x06,
        0x56,0xb2,0x90,0x93,0x1e,0x7f,0xa2,0x1c,0x06,0xc3,0x7c,0xf3,0x13,0x7b,0x21,0x81,
        0x3e,0x7d,0x05,0x7d,0xad,0xb6,0x1e,0x77,0x0c,0xbe,0x2c,0xea,0x02,0x52,0x88,0xcb,
        0xa8,0x6b,0xdf,0x8f,0x53,0x55,0x95,0xfd,0x98,0xf5,0x31,0xdc,0xae,0x06,0xfb,0xdc,
        0xfe,0xce,0xd2,0x7c,0x72,0x66,0x83,0x16,0x0c,0xd3,0xb3,0x8c,0x35,0x93,0x71,0xee,
        0xa9,0xde,0x82,0xf9,0x96,0x29,0xfd,0x31,0x1b,0x79,0x94,0xb9,0xd2,0x3c,0x06,0xea,
        0x45,0x8b,0xea,0xd1,0x27,0xa5,0x9a,0x6f,0x71,0x98,0x9e,0x92,0x96,0x3f,0xa4,0x02,
        0xb5,0x3e,0xe3,0xcb,0xb9,0xf0,0x35,0x51,0x72,0x5d,0x3e,0xc2,0x91,0x1a,0x21,0x9b,
        0x7b,0x3d,0x01,0x6a,0xc7,0xc3,0xc5,0x20,0xc3,0xbe,0x28,0xa2,0xf5,0x1c,0x58,0x6a,
        0xd9,0xe1,0x01,0xf0,0x9a,0xd8,0x13,0x23,0xe4,0x6c,0x6c,0xde,0x41,0x70,0x8c,0x89,
        0x05,0x7e,0x4e,0x00,0x3a,0x14,0x66,0x3c,0x34,0x7a,0xe7,0x0c,0x52,0xb4,0x2f,0x6f,
        0xc6,0x4f,0xfa,0x27,0x5f,0x99,0xe4,0x0b,0xf3,0x51,0x2f,0x39,0x94,0x38,0x53,0x59,
        0xb9,0xca,0x78,0x6a,0x2a,0x74,0xb6,0x37,0xf5,0x84,0xea,0xd0,0x0c,0xff,0xe7,0xaf,
        0xc5,0xd3,0x30,0x50,0x0c,0x4f,0xd8,0xb3,0x25,0xd5,0xf7,0x2e,0x8c,0x6e,0xe1,0xb8,
        0xf2,0x31,0x2a,0x38,0x9a,0xf5,0x97,0xa8,0x67,0x92,0xd3,0x48,0xed,0x05,0xe1,0x15,
        0x28,0xcc,0xfb,0x0a,0x9a,0xf2,0x96,0x9a,0xc6,0xfc,0x22,0xfc,0xca,0xb4,0x68,0x2b,
        0x17,0x0c,0xbc,0x61,0x20,0xf0,0x1e,0x02,0x58,0x48,0xdc,0x81,0xb3,0x49,0x10,0xe0,
        0x64,0x86,0xca,0x18,0x54,0x82,0xa1,0x9d,0x53,0xd5,0x5e,0x04,0x43,0x30,0xeb,0x64,
        0x96,0x3c,0xb3,0x1c,0x9b,0xe4,0x63,0xb5,0xe9,0x20,0x92,0x04,0x5d,0x06,0x8a,0x9e,
        0x2a,0x6a,0x74,0x27,0x6e,0xc5,0x27,0xef,0x89,0x0b,0x86,0xae,0x41,0xd3,0xe0,0xb1,
        0x6d,0xc3,0x28,0x7e,0x3a,0x1c,0xb4,0x91,0xdd,0xd8,0xb0,0xbd,0x2f,0x9d,0xc3,0xe7,
        0xe1,0x2c,0x46,0x04,0x68,0xd1,0x51,0x5f,0x54,0xef,0x39,0x7f,0x6e,0xd5,0xd1,0x5f,
        0x88,0xb4,0x0e,0xe6,0x94,0x63,0x3a,0x20,0x8e,0x8a,0xb1,0x1a,0x67,0xa6,0x65,0xab,
        0xb6,0x55,0x84,0x55,0x39,0x5b,0x1f,0xc7,0xa5,0xcd,0xfd,0x56,0xe0,0x5b,0x1b,0xe8,
        0x5f,0x8d,0x2a,0x79,0x81,0xc2,0xa3,0xec,0x02,0xd6,0x07,0x7f,0x1e,0x81,0x92,0x6d,
        0x76,0xda,0x2b,0x44,0x4a,0x6d,0xa0,0x9c,0x0f,0x2c,0x0f,0x53,0xea,0x0e,0x72,0x72,
        0x57,0x47,0x22,0x2c,0xe2,0x48,0x7c,0x2b,0x8d,0x17,0x97,0x4f,0xe7,0x63,0x59,0xf4,
        0x37,0x44,0xcf,0x53,0x67,0xcf,0x9a,0x37,0xfe,0x13,0xfd,0x37,0xbb,0xd3,0x97,0xcb,
        0x10,0x97,0x57,0x35,0x88,0x63,0xd5,0x34,0x58,0x4f,0xcf,0x7a,0x89,0x21,0x28,0x1d,
        0xe2,0x9c,0xc6,0x98,0x52,0xd3,0x82,0x48,0xcc,0xcc,0x13,0xfa,0x6d,0x25,0xcd,0xb8,
        0x84,0x63,0x7f,0xd8,0x1d,0x5d,0xd6,0x80,0xb2,0xd5,0xc6,0x8d,0x65,0xc6,0x89,0xd2,
        0x06,0x86,0xda,0x3b,0x3d,0xe9,0xf5,0xe4,0x6d,0x59,0x91,0xff,0x6e,0x83,0x45,0x67,
        0x3f,0x66,0xa4,0x18,0xe2,0x7c,0x0f,0x9a,0x0c,0x43,0xca,0x17,0xc8,0x51,0x0c,0x6a,
        0xed,0x1d,0x7d,0x27,0xab,0xde,0x99,0xae,0x68,0x4c,0xdd,0x65,0xa6,0xb7,0x52,0x40,
        0xbe,0x0a,0x9d,0x50,0x92,0x9b,0xb1,0xed,0x83,0x28,0x46,0xfd,0x04,0xdb,0xd9,0xd4,
        0x37,0x3f,0xa9,0x43,0x44,0x7c,0x23,0x15,0x86,0x8f,0xe3,0x26,0xaf,0xaf,0x86,0xae,
        0xe8,0xfa,0x5b,0x83,0x7b,0xab,0x06,0xaf,0xa7,0xb6,0xc7,0x6a,0xbe,0x5b,0x73,0x48,
        0x01,0x4b,0xb2,0x70,0x85,0xb7,0x0e,0x2a,0xeb,0xdc,0x9c,0x2c,0xc5,0xe8,0x13,0xc0,
        0x95,0xc6,0x93,0xd9,0xdf,0xa5,0x7d,0x2d,0xdc,0x2e,0x15,0x6d,0x6c,0x41,0x5d,0x45,
        0xe1,0x33,0xac,0x1c,0x26,0xa5,0x00,0x73,0xa2,0xe0,0x6a,0x90,0xe1,0x9f,0x91,0x86,
        0xe6,0x3a,0x9d,0x23,0x8a,0x22,0x08,0xe0,0x9f,0x41,0xd5,0x5a,0xb6,0x06,0x4f,0x54,
        0x1d,0x64,0x6e,0xd3,0x8f,0xd1,0xeb,0xd7,0x07,0x31,0x86,0x50,0x82,0xe6,0xf7,0xc7,
        0x31,0xdc,0x3a,0x47,0x75,0xca,0xe2,0x28,0x88,0xed,0x15,0x68,0x97,0xa0,0x23,0x47,
        0xdc,0x7b,0x86,0x75,0x7a,0x50,0x8b,0x26,0x12,0x4d,0x44,0x90,0x71,0xda,0x5b,0xe1,
        0x3d,0xa7,0x55,0x95,0xde,0x03,0x46,0x35,0x08,0xef,0x71,0xd5,0xa8,0xdf,0xc1,0x5d,
        0xab,0x0e,0xac,0x6a,0x2c,0x7d,0x75,0x31,0xdf,0xbd,0x24,0x5d,0x5a,0xce,0x44,0x99,
        0x9e,0x60,0x4c,0x68,0xe5,0xc5,0x53,0x59,0xb0,0x5c,0xb1,0xa4,0xba,0x19,0x3d,0x20,
        0x7d,0xbb,0x0a,0xcc,0xd4,0xff,0xb5,0xc2,0x9b,0x29,0xe3,0x57,0x0c,0xa8,0xec,0x12,
        0xdb,0x39,0xfe,0x1a,0xb0,0x1d,0x9b,0x41,0x7a,0xcb,0x56,0x7b,0xc3,0x5d,0xc7,0x09,
        0x98,0xc2,0xc8,0x15,0xd8,0xd1,0xb0,0x99,0x40,0x09,0x7f,0xc9,0xd8,0x24,0x41,0xb9,
        0x98,0x05,0x4d,0x5b,0x52,0xe3,0xcd,0x5f,0x98,0xd2,0xe9,0x52,0x4d,0x7c,0xe4,0x0d,
        0x2c,0x27,0xa6,0x83,0xd5,0xac,0xe8,0xe8,0xa2,0x50,0xc0,0x4e,0x4a,0xa2,0x9f,0xc9,
        0xda,0xe4,0x98,0xde,0x6c,0xdd,0xd6,0x54,0xeb,0x5c,0xac,0x47,0x48,0x20,0xcc,0x7d,
        0x58,0xae,0x85,0x61,0xf2,0x7e,0xb2,0x5e,0xc3,0xd8,0x2b,0xfe,0x70,0xd1,0xb4,0x12,
        0x06,0x99,0x80,0xde,0x14,0xec,0xc6,0x59,0x4e,0xa1,0x7a,0x88,0x75,0x63,0x36,0xcf,
        0x1a,0xff,0x97,0x03,0xc8,0xfc,0x77,0xfb,0xc6,0x59,0x86,0x8e,0x67,0xa6,0x3f,0xb5,
        0x7d,0xe8,0xd0,0x99,0x8d,0x5b,0xf3,0x92,0x59,0x28,0x6d,0x59,0xc5,0xd4,0xb9,0x77,
        0x1a,0x53,0x18,0xe0,0xaa,0x23,0x2c,0xde,0x08,0xcb,0x20,0xc5,0x84,0xb6,0x6d,0x4b,
        0xbc,0xb2,0x3b,0x55,0xa2,0x9a,0x38,0xa9,0x4f,0x6b,0x62,0x10,0x5b,0x52,0xb9,0x7c,
        0xbc,0x83,0x7c,0x46,0x7c,0x6f,0x72,0x11,0xc4,0x57,0xf8,0x76,0x03,0x2e,0x96,0x12,
        0x91,0xd1,0x53,0xa3,0x0b,0x88,0x2e,0x9d,0xec,0xa7,0x73,0xc5,0xfb,0xc8,0xe7,0x35,
        0xf0,0x1d,0x99,0xd2,0xb4,0xe1,0xa2,0x56,0x30,0xe5,0x93,0x9a,0x67,0xa3,0xf3,0x3c,
        0x9a,0x65,0x46,0x89,0xa5,0xeb,0x03,0xaa,0x9a,0x81,0x83,0x82,0x50,0xaa,0x9f,0x43,
        0xb2,0x9d,0xc7,0x29,0xa7,0x4b,0x8a,0xec,0xdf,0x61,0x0f,0xc0,0xee,0x71,0x09,0x9a,
        0x9d,0xbc,0xf2,0x9b,0x39,0xaa,0xc3,0x6d,0x52,0xe8,0x9c,0x98,0x87,0x1b,0x7f,0xf7,
        0xc9,0xb3,0x9a,0x37,0x9f,0x82,0xd3,0x44,0x69,0xde,0xcf,0xfc,0xfe,0xce,0x2b,0x8a,
        0x90,0x3c,0x66,0x4d,0x18,0xc1,0x5a,0x55,0x33,0x20,0xfb,0x84,0x36,0x6b,0x00,0x33,
        0xda,0x12,0x19,0xf9,0xbf,0x78,0xf2,0xdd,0x91,0xe1,0x7f,0xb6,0x1d,0x3b,0x59,0x4d,
        0xf3,0x54,0x2e,0x15,0xc1,0xda,0x52,0xb7,0xb5,0xd6,0xb2,0xed,0xf0,0xe7,0xe3,0xac,
        0x34,0x4f,0x0d,0x07,0x05,0xda,0xa8,0x5a,0x22,0x02,0x25,0x25,0xb0,0x20,0x7d,0xfb,
        0x64,0xf0,0x61,0x47,0xe7,0xd1,0x97,0x8d,0xa6,0xc0,0x79,0x4b,0x15,0x85,0xdb,0xb7,
        0x5b,0x94,0x72,0x8c,0x99,0xcd,0xe1,0x4a,0x2e,0xeb,0xe6,0x40,0x5d,0xe0,0x6d,0x97,
        0x3b,0xf8,0xe2,0xfd,0x55,0x7f,0x68,0x53,0x90,0xc0,0x88,0x9e,0x13,0x64,0x4e,0xdd,
        0xd0,0xc9,0xd2,0x60,0x18,0x14,0x60,0x90,0x9e,0x6c,0x1b,0x09,0x61,0x6a,0xca,0x7c,
        0xc8,0x4c,0xe0,0xad,0x6a,0xa8,0xee,0xcc,0xf3,0xdd,0xdc,0x21,0xc8,0x88,0x41,0x23,
        0x25,0x55,0x50,0x74,0xf1,0x51,0xab,0x67,0x6d,0x31,0x9f,0x33,0xeb,0x44,0x7e,0x09,
        0xee,0xd9,0xc3,0xd6,0x4f,0xb2,0x39,0xfd,0x1e,0x97,0x61,0x67,0xca,0x79,0x5e,0x13,
        0x72,0x1e,0xe1,0xeb,0xee,0xf2,0x1b,0x40,0xc5,0xdb,0x74,0x37,0x81,0x40,0xbb,0xb4,
        0x00,0xbc,0x6b,0xd8,0xb1,0xe3,0x1f,0x4a,0x97,0xcc,0x83,0xe9,0x69,0x95,0x13,0x93}, 
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),       
      },
};

const int TST_NumberOf_RC4AcceptanceTests = sizeof(TST_RC4_Acceptance_TestData)/sizeof(TST_RC4_Acceptance_TestData[0]);

/************* Private function prototype ***********************/
/************************ Public Functions ******************************/

/*****************************************************************************
* Function Name:                                                           
* 	CE2_ATP_TST_RC4_Acceptance_integrated 		
* 
* Inputs:
* 	None
*
* Outputs:
* 	CE2Error_t - Function error return		    					  		
*
* Description:																	
* 	This function Is a Acceptance test for RC4 non integrated API's							
* 	This function Encryprts and Decrypts known vectors using RC4 
* 	Vector sizes used (in bytes) - 16/32/45/512/1536									
* 	Key Size used (in bytes)	- 16/32/45/512								
* 	This also outputs the results to an output buffer or the same input buffer
* Algorithm:		
* 1. Call the CE2_RC4_to Preform the encryprion/decryption process
* 2. Compare the outputted result to the expected one													
*
******************************************************************************/	
CE2Error_t CE2_ATP_TST_RC4_Acceptance_Integrated(FILE* out)
{
  int TST_index, cmp_result;
  CE2Error_t result = CE2_OK, error;

  PrintTestBeginMsg(out, __FUNCTION__);

  for (TST_index = 0 ; TST_index < TST_NumberOf_RC4AcceptanceTests ; TST_index++) /*To run on all test vectors*/
  {
    error = CE2_RC4(TST_RC4_Acceptance_TestData[TST_index].TST_Key,
      TST_RC4_Acceptance_TestData[TST_index].TST_KeySize,
      TST_RC4_Acceptance_TestData[TST_index].TST_input_data,
      TST_RC4_Acceptance_TestData[TST_index].TST_dataSize,
      TST_RC4_Acceptance_TestData[TST_index].TST_output_data); 
    if (error != CE2_OK) {
      fprintf(out, "Can't make RC4.\n");
      fprintf(out, "    %s [test %d]  **\n", 
        TST_RC4_Acceptance_TestData[TST_index].TST_Name, TST_index);   
      result |= CE2_TST_FAILED;
      continue;
    }

    cmp_result = memcmp(TST_RC4_Acceptance_TestData[TST_index].TST_output_data ,
      TST_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data ,
      TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);
    if (cmp_result != 0) {
      fprintf(out, "CE2_RC4 return wrong output data.\n");
      fprintf(out, "    %s [test %d]  **\n", 
        TST_RC4_Acceptance_TestData[TST_index].TST_Name, TST_index);   
      result |= CE2_TST_FAILED;
      continue;
    }
  }/*End of TST_index//TST_NumberOf_RC4_AcceptanceTests*/     

  PrintTestEndMsg(out, __FUNCTION__, result);

  return result;
}

